<?php

declare(strict_types=1);

namespace Erlage\Photogram\Helpers;

use Erlage\Photogram\Constants\ServerConstants;

trait TraitFeedHelper
{
    /**
     * @var string
     */
    private static $feedType;

    /**
     * @var string
     */
    private static $loadType;

    private static function feedHelperInit(string $feedType, string $loadType): void
    {
        self::$feedType = $feedType;
        self::$loadType = $loadType;
    }

    private static function isLoadingLatestContent(): bool
    {
        return self::$loadType == ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST;
    }

    private static function isLoadingOldContent(): bool
    {
        return self::$loadType == ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM;
    }

    private static function isLoadingFollowers(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWERS;
    }

    private static function isLoadingFollowing(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWINGS;
    }

    private static function isLoadingForProfilePage(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE;
    }

    private static function isLoadingForNewsFeedsPage(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL;
    }

    private static function isLoadingForHashtagPage(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_SINGLE;
    }

    private static function isLoadingForExplorePage(): bool
    {
        return self::$feedType == ServerConstants::SERVER_CONST_FEED_TYPE_GLOBAL;
    }
}
